#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  fiore.py
#  
#  Copyright 2017 luca <luca@luca-Ubunru16>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#  
#  
import turtle
import random


#Funzione che disegna un triangolo equilatero	
#e lo riempie con un colore scelto a caso dalla lista definita oltre
def Triangolo(lato):
	colori=random.sample(lista_colori,1)
	t.fillcolor(colori[0])
	t.begin_fill()
	t.down()
	for n in range(3):
		t.fd(lato)
		t.left(120)
	t.end_fill()
	t.up()

#Funzione che disegna il triangolo di Sierpinski
def Sierpinski(lato, livello):
	if(livello==0):
		Triangolo(lato)
	else:
		Sierpinski(lato/2, livello-1)
		t.fd(lato/2)
		Sierpinski(lato/2, livello-1)
		t.left(120)
		t.fd(lato/2)
		t.right(120)
		Sierpinski(lato/2, livello-1)
		t.right(120)
		t.fd(lato/2)
		t.left(120)


print ("Disegnerò un triangolo di sirpinski")
risposta=input("quanti livelli vuoi? (min 0 max 7) ")
livello=int(risposta)
if (livello < 0 or livello >= 8):
        print("input non valido : %s" %risposta)
        quit()
        
risposta=input("quale velocità vuoi? (0:lentissimo 1:lento 2:normale 3:veloce 4:velocissimo)")
velocita=int(risposta)
if (velocita < 0 or velocita > 4 ):
        print("input non valido : %s" %risposta)
        quit()
lista_colori = ['red','green','orange','blue','lightblue','violet','brown','pink','magenta','darkgreen','chocolate','aqua', 'darkcyan', 'deeppink', 'greenyellow','mediumorchid', 'darkorchid', 'darkviolet', 'blueviolet', 'purple', 'papayawhip', 'blanchedalmond', 'bisque', 'peachpuff','navajowhite', 'lemonchiffon', 'mintcream', 'azure', 'aliceblue', 'lavender','lavenderblush', 'mistyrose', 'darkslategray', 'dimgray', 'slategray','lightslategray', 'gray', 'lightgrey', 'midnightblue', 'navy','cornflowerblue', 'darkslateblue','slateblue', 'mediumslateblue', 'lightslateblue', 'mediumblue','royalblue','blue','dodgerblue', 'deepskyblue', 'skyblue', 'lightskyblue', 'steelblue', 'lightsteelblue', 'lightblue', 'powderblue', 'paleturquoise', 'darkturquoise', 'mediumturquoise', 'turquoise','cyan', 'lightcyan', 'cadetblue', 'mediumaquamarine', 'aquamarine', 'darkgreen', 'darkolivegreen', 'darkseagreen', 'seagreen', 'mediumseagreen', 'lightseagreen', 'palegreen', 'springgreen','lawngreen', 'mediumspringgreen', 'greenyellow', 'limegreen', 'yellowgreen','forestgreen', 'olivedrab', 'darkkhaki', 'khaki', 'palegoldenrod', 'lightgoldenrodyellow','lightyellow', 'yellow', 'gold', 'lightgoldenrod', 'goldenrod', 'darkgoldenrod', 'rosybrown','indianred', 'saddlebrown', 'sandybrown','darksalmon', 'salmon', 'lightsalmon', 'orange', 'darkorange','coral', 'lightcoral', 'tomato', 'orangered', 'red', 'hotpink', 'deeppink', 'pink', 'lightpink','palevioletred', 'maroon', 'mediumvioletred', 'violetred','mediumorchid', 'darkorchid', 'darkviolet', 'blueviolet', 'purple', 'mediumpurple', 'thistle', 'snow2', 'snow3','snow4', 'seashell2', 'seashell3', 'seashell4', 'AntiqueWhite1', 'AntiqueWhite2','AntiqueWhite3', 'AntiqueWhite4', 'bisque2', 'bisque3', 'bisque4', 'PeachPuff2', 'PeachPuff3', 'PeachPuff4', 'NavajoWhite2', 'NavajoWhite3', 'NavajoWhite4',    'LemonChiffon2', 'LemonChiffon3', 'LemonChiffon4', 'cornsilk2', 'cornsilk3', 'cornsilk4', 'ivory2', 'ivory3', 'ivory4', 'honeydew2', 'honeydew3', 'honeydew4', 'LavenderBlush2', 'LavenderBlush3', 'LavenderBlush4', 'MistyRose2', 'MistyRose3', 'MistyRose4', 'azure2', 'azure3', 'azure4', 'SlateBlue1', 'SlateBlue2', 'SlateBlue3', 'SlateBlue4', 'RoyalBlue1', 'RoyalBlue2', 'RoyalBlue3', 'RoyalBlue4', 'blue2', 'blue4','DodgerBlue2', 'DodgerBlue3', 'DodgerBlue4', 'SteelBlue1', 'SteelBlue2', 'SteelBlue3', 'SteelBlue4', 'DeepSkyBlue2', 'DeepSkyBlue3', 'DeepSkyBlue4','SkyBlue1', 'SkyBlue2', 'SkyBlue3', 'SkyBlue4', 'LightSkyBlue1', 'LightSkyBlue2','LightSkyBlue3', 'LightSkyBlue4', 'SlateGray1', 'SlateGray2', 'SlateGray3','SlateGray4', 'LightSteelBlue1', 'LightSteelBlue2', 'LightSteelBlue3','LightSteelBlue4', 'LightBlue1', 'LightBlue2', 'LightBlue3', 'LightBlue4', 'LightCyan2', 'LightCyan3', 'LightCyan4', 'PaleTurquoise1', 'PaleTurquoise2', 'PaleTurquoise3', 'PaleTurquoise4', 'CadetBlue1', 'CadetBlue2', 'CadetBlue3', 'CadetBlue4', 'turquoise1', 'turquoise2', 'turquoise3', 'turquoise4', 'cyan2', 'cyan3', 'cyan4', 'DarkSlateGray1']


t=turtle.Pen()
turtle.screensize(800,800)
turtle.title("triangolo di Sierpinski:")

t.penup()
t.setpos(-230,270)
t.write("Sierpinski", move=False, align="left", font=("Arial", 14, "normal"))
t.setpos(-230,240)
t.write("livello: %s" %livello, move=False, align="left", font=("Arial", 14, "normal"))
turtle.delay(10)

lista_velocita=['slowest','slow','normal','fast','fastest']
lato = 600       
t.setpos((-300,-200))
t.pen(pensize=2)
t.speed(lista_velocita[velocita])
#richama la funzione 
Sierpinski(lato, livello)

t.penup()	
t.setpos(-150,-270)
t.write("fai click per uscire", move=False, align="left", font=("Arial", 18, "normal"))
turtle.exitonclick()


		


